﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Preview.HIO
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using Communications;
    using NintendoWare.Preview.HIO.Sound;

    /// <summary>
    /// リセット
    /// <para>
    /// ビューアをリセットするためのパケットです。
    /// </para>
    /// </summary>
    public class HIOResetPacket : HIOToolPacket
    {
#if false
        /// <summary>
        /// メッセージタイプ
        /// </summary>
        public override Message Message
        {
            get
            {
                return Message.SoundReset;
            }
        }
#endif

        /// <summary>
        /// パケットタイプ
        /// </summary>
        public override ushort PacketType
        {
            get { return Constants.TOOL_SOUND_ECHO; }   //@@ テスト
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// パケットを送信します。
        /// </summary>
        public static void Send()
        {
            /// とりあえず送らないことにする
#if false
            if (!CommManager.Instance.IsConnected)
            {
                return;
            }

            HIOResetPacket packet = new HIOResetPacket();
            CommManager.Instance.SendPacket(packet);
#endif
        }
    }
}
