﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Preview.HIO
{
  using System;
  using System.Diagnostics;
  using System.IO;
  using System.Text;
  using Communications;
  using NW4R.ProtocolSound;

    /// <summary>
    /// HIOパケット
    /// <para>
    /// HIO通信で送受信されるパケットのベースクラスです。
    /// </para>
    /// </summary>
    public abstract class HIOPacket : CommPacket
    {
        /// <summary>
        /// メッセージタイプ
        /// </summary>
        //public abstract Message Message { get; }

#if false
        /// <summary>
        /// メッセージをカテゴリを取得します。
        /// </summary>
        public MessageCategory MessageCategory
        {
            get
            {
                return (MessageCategory)(this.Message & MessageUtilitiy.CategoryMask);
            }
        }
#endif

      /// <summary>
      /// パケットのカテゴリ
      /// </summary>
      public ushort Category
      {
        get
        {
          return (ushort)(PacketType & Constants.HEADER_CATEGORY_MASK);
        }
      }


      /// <summary>
      /// 返信フラグ
      /// </summary>
      public bool Reply
      {
        get
        {
          return ((PacketType & Constants.HEADER_REPLY_FLAG) != 0);
        }
      }
        //-----------------------------------------------------------------

        /// <summary>
        /// 読み込み
        /// </summary>
#if false
        public virtual void Read(
            BinaryReader reader, PacketHeader header)
        {
            // デフォルトの動作は内容無しのパケットを想定
            Debug.Assert(header.DataSize == 0);
        }

        /// <summary>
        /// 書き出し
        /// </summary>
        public virtual PacketHeader Write(BinaryWriter writer)
        {
            // デフォルトの動作は内容無しのパケットを想定
            Debug.Assert(Size == 0);

            var header = CreateHeader();
            header.Write(writer);

            return header;
        }
#else
        public virtual void Read(
            ProtocolSoundReader reader, HIOPacketHeader header)
        {
            // デフォルトの動作は内容無しのパケットを想定
            //Debug.Assert(header.DataSize == 0);
        }

        public virtual HIOPacketHeader Write(ProtocolSoundWriter writer)
        {
            // デフォルトの動作は内容無しのパケットを想定
            Debug.Assert(Size == 0, "Size is zero");

            var header = CreateHeader();
            header.Write(writer);

            return header;
        }
#endif

        /// <summary>
        /// 文字列変換
        /// </summary>
        public override string ToString()
        {
            return this.GetType().Name + " " + CreateHeader().ToString();
        }

        /// <summary>
        /// パケットの種類
        /// </summary>
        public abstract ushort PacketType{ get; }

        /// <summary>
        /// サイズ
        /// </summary>
        public virtual ushort Size { get { return 0; } }

        //---------------------------------------------------------------------
        /// <summary>
        /// メッセージ
        /// </summary>
        protected static void ShowMessage(string format, params object[] args)
        {
            CommManager.Instance.Console.WriteMessage(format, args);
        }

        /// <summary>
        /// エラー
        /// </summary>
        protected static void ShowError(string format, params object[] args)
        {
            throw new ApplicationException(string.Format(format, args));
        }

        /// <summary>
        /// ヘッダの作成
        /// </summary>
        protected HIOPacketHeader CreateHeader()
        {
            //return new HIOPacketHeader(Message, Size);
            return new HIOPacketHeader(PacketType, Size);
        }

        //---------------------------------------------------------------------
        // 非公開メンバ
        //---------------------------------------------------------------------
        /// <summary>
        /// コンストラクタ
        /// </summary>
        protected HIOPacket() { }

        //---------------------------------------------------------------------
        /// <summary>
        /// ファイルパスのエンコード
        /// </summary>
        protected void EncodeFilePath(string filePath, byte[] byteArray)
        {
            if (Encoding.Default.GetByteCount(filePath) > byteArray.Length)
            {
                ShowError("ファイルパスが長すぎます", filePath);
            }
            Encoding.Default.GetBytes(
                filePath, 0, filePath.Length, byteArray, 0);
        }
    }
}
