﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
//using MCS;
using NW4R.ProtocolSound;

namespace NintendoWare.Preview.HIO.Error
{
    /// <summary>
    /// MCSエラーパケット
    /// <para>
    /// MCS通信で送受信されるエラーパケットのベースクラスです。
    /// </para>
    /// </summary>
    public abstract class HIOErrorPacket : HIOPacket
    {
        //---------------------------------------------------------------------
        // 公開メンバ
        //---------------------------------------------------------------------
        /// <summary>
        /// エラーパケットの作成
        /// </summary>
        public static HIOErrorPacket Create(
            HIOPacketHeader header, HIOPacket target)
        {
            // 分類分けを行う
            HIOErrorPacket packet = null;

            switch( header.PacketType & Constants.HEADER_CATEGORY_MASK ) {
            case Constants.CATEGORY_SYSTEM:
                //packet = MCSSystemErrorPacket.CreateSystemErrorPacket( header.PacketType, target );
                break;

            case Constants.CATEGORY_3D:
                //packet = MCS3DErrorPacket.Create3DErrorPacket( header.PacketType, target );
                break;

            case Constants.CATEGORY_SOUND:
                packet = Sound.HIOSoundErrorPacket.CreatePacket( header.PacketType, target );
                break;
            }

            return packet;
        }

        //---------------------------------------------------------------------
        /// <summary>
        /// 読み込み
        /// </summary>
        public override void Read(
            ProtocolSoundReader reader, HIOPacketHeader header)
        {
            // 必ずサブクラスでエラーに対処する必要がある
            Debug.Assert(false, "Not override Read method");
        }

        //---------------------------------------------------------------------
        /// <summary>
        /// エラーを起こしたパケット
        /// </summary>
        public HIOPacket Target{ get{ return _target; } }

        //---------------------------------------------------------------------
        // 非公開メンバ
        //---------------------------------------------------------------------
        /// <summary>
        /// コンストラクタ
        /// </summary>
        protected HIOErrorPacket(HIOPacket target)
        {
            //Debug.Assert(!Reply);
            //Debug.Assert(Error);
            _target = target;
        }

        // エラーを起こしたパケット
        private readonly HIOPacket _target;
    }
}
