﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.Preview.Configurations
{
    using NintendoWare.SoundMaker.Configurations.Schemas;

    public class ChorusConverter : EffectConverter<XmlChorus, ChorusParameter>
    {
        protected override void ApplyParameters(XmlChorus xmlEffect, ChorusParameter effectParameter)
        {
            effectParameter.DelayTime = xmlEffect.DelayTime;
            effectParameter.Depth = xmlEffect.Depth;
            effectParameter.Rate = xmlEffect.Rate;
            effectParameter.Feedback = xmlEffect.Feedback;
            effectParameter.OutGain = xmlEffect.OutGain;
        }

        protected override void ExtractParameters(ChorusParameter effectParameter, XmlChorus xmlEffect)
        {
            xmlEffect.DelayTime = effectParameter.DelayTime;
            xmlEffect.Depth = effectParameter.Depth;
            xmlEffect.Rate = effectParameter.Rate;
            xmlEffect.Feedback = effectParameter.Feedback;
            xmlEffect.OutGain = effectParameter.OutGain;
        }
    }
}
