﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    /// <summary>
    /// バンクドキュメントの読み込みをサポートします。
    /// </summary>
    public class BankDocumentReaderCafe : BankDocumentReader
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public BankDocumentReaderCafe()
        {
            this.DocumentTypeName = Platforms.Cafe.BankDocument;
            this.DocumentVersion = Platforms.Cafe.BankDocumentVersion;
            this.Platform = Platforms.Cafe.PlatformName;
        }

        public override string GetFileVersion(string filePath)
        {
            return "0.0.0.0";
        }
    }
}
