﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using NintendoWare.SoundFoundation.Core.Parameters;

    public class SequenceSound : SequenceSoundBase
    {
        ///--------------------------------
        /// <summary>
        /// リモコン
        /// </summary>
        public int RemoteFilter
        {
            get { return GetIntValue(ProjectParameterNamesCommon.RemoteFilter); }
            set { SetIntValue(ProjectParameterNamesCommon.RemoteFilter, value); }
        }

        ///--------------------------------
        /// <summary>
        /// パラメータを初期化します。
        /// </summary>
        protected override void InitializeParameters()
        {
            base.InitializeParameters();

            SetInstanceIntValue(ProjectParameterNamesCommon.RemoteFilter, 0, 0, 127);

#if false
            SetInstanceBoolValue(ProjectParameterNamesCommon.SndEdit, false);
            SetInstanceBoolValue(ProjectParameterNamesCommon.SndEditEnabled, false);
#endif

            // サウンドアーカイブバイナリ依存パラメータ
            this.SetParameterAttributes(ProjectParameterNamesCommon.RemoteFilter, ParameterAttributes.ComputeSoundArchiveHash);
        }
    }
}
