﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using Binarization;
    using ToolDevelopmentKit;

    /// <summary>
    /// 共通ブロックの名前を取得するクラスです。
    /// </summary>
    internal class CommonBlockNameProvider : IDomElementFieldNameProvider
    {
        /// <summary>
        /// DOM要素フィールド名を取得または設定します。
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 指定した値からDOM要素フィールド名を取得します。
        /// </summary>
        /// <param name="value">値を指定します。</param>
        /// <returns>DOM要素フィールドの名前を返します。</returns>
        public string GetNameFromValue(DomElement parent, object value)
        {
            Assertion.Argument.True(value is CommonBlock);
            return (value as CommonBlock).Header.Signature;
        }
    }
}
