﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Runtime.InteropServices;
    using Binarization;
    using ToolDevelopmentKit;

    [StructLayout(LayoutKind.Sequential)]
    internal class ParameterBytes : IParameterValue
    {
        private Byte[] value = new Byte[] { 0, 0, 0, 0 };

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public UInt32 Value
        {
            get
            {
                UInt32 result = value[0];
                result |= (UInt32)value[1] << 8;
                result |= (UInt32)value[2] << 16;
                result |= (UInt32)value[3] << 24;

                return result;
            }

            set
            {
                Ensure.Argument.NotNull(value);
                this.value = BitConverter.GetBytes(value);

                Ensure.Argument.True(this.value.Length == 4);
            }
        }

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        public Byte[] Bytes
        {
            get { return value; }
            set
            {
                Ensure.Argument.NotNull(value);
                Ensure.Argument.True(value.Length == 4);
                this.value = value;
            }
        }

        [DomIgnoreField]
        object IParameterValue.Value
        {
            get { return this.Value; }
            set
            {
                if (value is Byte[])
                {
                    this.Bytes = (Byte[])value;
                    return;
                }

                if (value is UInt32)
                {
                    this.Value = (UInt32)value;
                    return;
                }

                Ensure.Operation.True(false);
            }
        }
    }
}
