﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveXmlElements
{
    using System;
    using System.Globalization;
    using System.Xml;
    using System.Xml.Serialization;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// ファイル情報を格納します。
    /// </summary>
    [Serializable]
    public abstract class FileXml
    {
        /// <summary>
        /// 16進数表記の ID（テキスト）を取得または設定します。
        /// </summary>
        [XmlAttribute("ID")]
        public string IDText { get; set; }

        [XmlAttribute("Name")]
        public string Name { get; set; }

        /// <summary>
        /// 16進数表記の ID（数値）を取得または設定します。
        /// </summary>
        [XmlIgnore]
        internal UInt32 ID
        {
            get
            {
                if (this.IDText == null || this.IDText.Length == 0)
                {
                    return BinaryItemID.InvalidValue;
                }

                return UInt32.Parse(this.IDText, NumberStyles.HexNumber);
            }
            set
            {
                Ensure.Argument.NotNull(value);
                this.IDText = value.ToString("X8");
            }
        }
    }
}
