﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveElements
{
    using System.Collections.Generic;
    using System.Runtime.InteropServices;
    using Binarization;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    internal class StringBlockBody
    {
        public StringBlockBody()
        {
            this.StringTable = new StringTable();
            this.PatriciaTree = new PatriciaTreeBinary();

            this.References = new object[]
            {
                this.StringTable,
                this.PatriciaTree,
            };
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        [DomObjectReference(
            OriginTag = "Element", HasType = true, HasOffset = true)]
        public IEnumerable<object> References { get; private set; }

        [DomPreAlignment(4)]
        public StringTable StringTable { get; private set; }

        [DomPreAlignment(4)]
        public PatriciaTreeBinary PatriciaTree { get; private set; }
    }
}
