﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Runtime.InteropServices;
    using Binarization;
    using Projects;

    [StructLayout(LayoutKind.Sequential)]
    internal class ParameterStreamTypeInfoParam : ParameterBytes
    {
        private const int ContainerTypeIndex = 0;
        private const int IsLoopedIndex = 1;
        private const int DecodeTypeIndex = 2;

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        // 基底クラス CommonFileRoot のデータ構造と同じです。

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        public ContainerType ContainerType
        {
            get { return ToContainerType(this.Bytes[ContainerTypeIndex]); }
            set { this.Bytes[ContainerTypeIndex] = FromContainerType(value); }
        }

        [DomIgnoreField]
        public bool IsLooped
        {
            get { return this.Bytes[IsLoopedIndex] == 1; }
            set { this.Bytes[IsLoopedIndex] = (Byte)(value ? 1 : 0); }
        }

        [DomIgnoreField]
        public DecodeType DecodeType
        {
            get { return ToDecodeType(this.Bytes[DecodeTypeIndex]); }
            set { this.Bytes[DecodeTypeIndex] = FromDecodeType(value); }
        }

        private ContainerType ToContainerType(Byte value)
        {
            return (ContainerType)value;
        }

        private Byte FromContainerType(ContainerType value)
        {
            return (Byte)value;
        }

        private DecodeType ToDecodeType(Byte value)
        {
            return (DecodeType)value;
        }

        private Byte FromDecodeType(DecodeType value)
        {
            return (Byte)value;
        }
    }
}
