﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Runtime.InteropServices;
    using Binarization;
    using ToolDevelopmentKit;

    [StructLayout(LayoutKind.Sequential)]
    internal class ParameterPlayerParam : ParameterBytes
    {
        private const int PlayerPriorityIndex = 0;
        private const int ActoryPlayerIDIndex = 1;

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        // 基底クラス CommonFileRoot のデータ構造と同じです。

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        public Byte PlayerPriority
        {
            get { return this.Bytes[PlayerPriorityIndex]; }
            set { this.Bytes[PlayerPriorityIndex] = value; }
        }

        [DomIgnoreField]
        public Byte ActoryPlayerID
        {
            get { return this.Bytes[ActoryPlayerIDIndex]; }
            set { this.Bytes[ActoryPlayerIDIndex] = value; }
        }
    }
}
