﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Collections.Specialized;
    using System.Runtime.InteropServices;
    using Binarization;
    using Projects;
    using SoundArchiveElements;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    [DomElementType(Value = (UInt16)ElementType.Parameter_Sound3D)]
    internal class ParameterSound3D
    {
        private Sound3DParameterArray parameters = new Sound3DParameterArray();
        private BitVector32 flags = new BitVector32(0);
        private int bit1, bit2, bit3, bit4, bit5;

        public ParameterSound3D()
        {
            bit1 = BitVector32.CreateMask();
            bit2 = BitVector32.CreateMask(bit1);
            bit3 = BitVector32.CreateMask(bit2);
            bit4 = BitVector32.CreateMask(bit3);
            bit5 = BitVector32.CreateMask(bit4);
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public UInt32 Flags { get { return (UInt32)(this.flags.Data); } }

        public float DecayRatio { get; set; }

        [DomConvertTo(typeof(DecayCurve3D2ByteConverter))]
        public DecayCurve3D DecayCurveType { get; set; }

        public Byte DopplerFactor { get; set; }

        public UInt16 Padding
        {
            get { return 0; }
        }

        public Sound3DParameterArray Parameters
        {
            get { return this.parameters; }
        }

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        public bool Volume3D
        {
            get { return this.flags[bit1]; }
            set { this.flags[bit1] = value; }
        }

        [DomIgnoreField]
        public bool Priority3D
        {
            get { return this.flags[bit2]; }
            set { this.flags[bit2] = value; }
        }

        [DomIgnoreField]
        public bool Pan3D
        {
            get { return this.flags[bit3]; }
            set { this.flags[bit3] = value; }
        }

        [DomIgnoreField]
        public bool SPan3D
        {
            get { return this.flags[bit4]; }
            set { this.flags[bit4] = value; }
        }

        [DomIgnoreField]
        public bool Filter3D
        {
            get { return this.flags[bit5]; }
            set { this.flags[bit5] = value; }
        }
    }
}
