﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveElements
{
    using System;
    using System.Collections.Generic;
    using System.Runtime.InteropServices;
    using Binarization;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    [DomElementType(Value = (UInt16)ElementType.SoundArchiveFile_StreamSoundInfo)]
    internal class StreamSoundInfo
    {
        public StreamSoundInfo()
        {
            this.TrackInformationTable = new ReferenceTable<StreamSoundTrackInfo>();

            this.TrackInformations = new List<StreamSoundTrackInfo>();
            this.TrackInformationTable.Items = this.TrackInformations;

            this.PrefechFileID = UInt32.MaxValue;   // 無効値を設定
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public UInt16 TrackAllocationFlags { get; set; }

        public UInt16 TotalChannelCount { get; set; }

        [DomObjectReference(
            OriginTag = "Element", HasType = true, HasOffset = true)]
        public ReferenceTable<StreamSoundTrackInfo> TrackInformationTableReference
        {
            get { return this.TrackInformationTable; }
        }

        public Single Pitch { get; set; }

        [DomObjectReference(
            OriginTag = "Element", HasType = true, HasOffset = true)]
        public SendInfo SendInfoReference
        {
            get { return this.SendInfo; }
        }

        [DomObjectReference(
            OriginTag = "Element", HasType = true, HasOffset = true)]
        public StreamSoundExtensionInfo StreamSoundExtensionInfoReference
        {
            get { return this.StreamSoundExtensionInfo; }
        }

        public UInt32 PrefechFileID { get; set; }

        public ReferenceTable<StreamSoundTrackInfo> TrackInformationTable { get; private set; }

        public List<StreamSoundTrackInfo> TrackInformations { get; private set; }

        public SendInfo SendInfo { get; set; }

        [DomField(IsOptional = true)]
        public StreamSoundExtensionInfo StreamSoundExtensionInfo { get; set; }
    }
}
