﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.BankElements
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.Runtime.InteropServices;
    using Binarization;
    using Projects;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    [DomElementType(Value = (UInt16)ElementType.BankFile_NullInfo)]
    internal class NullInfo : IInstrumentItem
    {
        private byte rangeMin = 0;
        private byte rangeMax = 0;

        public NullInfo(byte rangeMin, byte rangeMax)
        {
            this.rangeMin = rangeMin;
            this.rangeMax = rangeMax;
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        // データなし

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        public Byte RangeMin
        {
            get { return this.rangeMin; }
        }

        [DomIgnoreField]
        public Byte RangeMax
        {
            get { return this.rangeMax; }
        }
    }
}
