﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.BankElements
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.Runtime.InteropServices;
    using NintendoWare.SoundFoundation.Binarization;
    using NintendoWare.SoundFoundation.Projects;

    [StructLayout(LayoutKind.Sequential)]
    internal abstract class NoteInfo
    {
        private InstrumentNoteInfoParameterArray parameters = new InstrumentNoteInfoParameterArray();

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        /// <summary>
        /// バンクファイル内の波形IDインデックスを取得または設定します。
        /// </summary>
        public UInt32 WaveIDIndex { get; set; }

        /// <summary>
        /// ノート情報パラメータを取得します。
        /// </summary>
        public InstrumentNoteInfoParameterArray Parameters
        {
            get { return this.parameters; }
        }
    }
}
