﻿namespace NintendoWare.SoundFoundation.FileFormats.NintendoSdkBinary.WaveSound2Elements
{
    using NintendoWare.SoundFoundation.Binarization;
    using System;
    using System.Collections.Generic;
    using System.Runtime.InteropServices;

    /// <summary>
    /// トラックバイナリの構成を定義します。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    internal class TrackBinary
    {
        private IList<ClipBinary> clips = new List<ClipBinary>();

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public TrackBinary()
        {
            this.ClipTable = new ReferenceTable<ClipBinary>();
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public UInt32 ReservedForCurveTableOffset
        {
            get { return 0; }
        }

        /// <summary>
        /// クリップテーブルへのオフセットを出力するために、クリップテーブルへの参照を取得します。
        /// </summary>
        [DomObjectReference(OriginTag = "Element", HasOffset = true)]
        public ReferenceTable<ClipBinary> ClipTableReference
        {
            get { return this.ClipTable; }
        }

        /// <summary>
        /// クリップテーブルの実体を取得します。
        /// </summary>
        public ReferenceTable<ClipBinary> ClipTable { get; private set; }

        // NOTE : クリップの実体は、Track の外に配置するため、ここでは定義していません。
    }
}
