﻿namespace NintendoWare.SoundFoundation.FileFormats.NintendoSdkBinary
{
    using NintendoWare.SoundFoundation.Binarization;
    using NintendoWare.SoundFoundation.FileFormats.NintendoSdkBinary.WaveSound2Elements;
    using System.Runtime.InteropServices;

    /// <summary>
    /// WaveSound2 バイナリの構造を定義します。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    internal class WaveSound2Binary : BinaryFileRoot
    {
        private InfoBlock infoBlock = new InfoBlock();

        internal WaveSound2Binary()
            : base("BAWSD   ", NintendoSdkBinaryVersions.WaveSound2BinaryVersion)
        {
            this.Blocks.Add(this.infoBlock);
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        // 基底クラス BinaryFileRoot のデータ構造と同じです。

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        /// <summary>
        /// INFO ブロックを取得します。
        /// </summary>
        [DomIgnoreField]
        public BinaryBlock<InfoBlockBody> InfoBlock
        {
            get { return this.infoBlock; }
        }
    }
}
