﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using NintendoWare.SoundFoundation.Core.Parameters;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.ToolDevelopmentKit;

    public static class StreamSoundTrackExtension
    {
        public static uint GetChannelCount(this StreamSoundTrackBase track)
        {
            Ensure.Argument.NotNull(track);

            if (!track.Parameters.ContainsKey(ConversionParameterNames.StreamSoundTrack.ChannelCount))
            {
                track.Parameters.AddValue(
                    ConversionParameterNames.StreamSoundTrack.ChannelCount, new UIntParameterValue(0));
            }

            return (uint)track.Parameters[ConversionParameterNames.StreamSoundTrack.ChannelCount].Value;
        }

        public static void SetChannelCount(this StreamSoundTrackBase track, uint value)
        {
            Ensure.Argument.NotNull(track);

            if (!track.Parameters.ContainsKey(ConversionParameterNames.StreamSoundTrack.ChannelCount))
            {
                track.Parameters.AddValue(
                    ConversionParameterNames.StreamSoundTrack.ChannelCount, new UIntParameterValue(0));
            }

            track.Parameters[ConversionParameterNames.StreamSoundTrack.ChannelCount].Value = value;
        }

        public static bool IsPreprocessed(this StreamSoundTrackBase track, string preprocessedTag)
        {
            Assertion.Argument.NotNull(track);

            if (!string.IsNullOrEmpty(preprocessedTag))
            {
                return track.Comment.Contains(preprocessedTag) ||
                    track.Comment1.Contains(preprocessedTag) ||
                    track.Comment2.Contains(preprocessedTag) ||
                    track.Comment3.Contains(preprocessedTag) ||
                    track.Comment4.Contains(preprocessedTag) ||
                    track.Comment5.Contains(preprocessedTag) ||
                    track.Comment6.Contains(preprocessedTag) ||
                    track.Comment7.Contains(preprocessedTag) ||
                    track.Comment8.Contains(preprocessedTag) ||
                    track.Comment9.Contains(preprocessedTag);
            }

            return false;
        }
    }
}
