﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System.Collections.Generic;
    using Core.Parameters;
    using Projects;
    using ToolDevelopmentKit;

    public static class SequenceSoundEx
    {
        public static uint GetConversionStartOffset(this SequenceSoundBase sequenceSound)
        {
            return sequenceSound.GetStartOffset();
        }

        public static uint GetStartOffset(this SequenceSoundBase sequenceSound)
        {
            Ensure.Argument.NotNull(sequenceSound);

            if (!sequenceSound.Parameters.ContainsKey(ConversionParameterNames.SequenceSound.StartOffset))
            {
                sequenceSound.Parameters.AddValue(
                    ConversionParameterNames.SequenceSound.StartOffset, new UIntParameterValue(uint.MaxValue));
            }

            return (uint)sequenceSound.Parameters[ConversionParameterNames.SequenceSound.StartOffset].Value;
        }

        public static void SetStartOffset(this SequenceSoundBase sequenceSound, uint value)
        {
            Ensure.Argument.NotNull(sequenceSound);

            if (!sequenceSound.Parameters.ContainsKey(ConversionParameterNames.SequenceSound.StartOffset))
            {
                sequenceSound.Parameters.AddValue(
                    ConversionParameterNames.SequenceSound.StartOffset, new UIntParameterValue());
            }

            sequenceSound.Parameters[ConversionParameterNames.SequenceSound.StartOffset].Value = value;
        }

        public static uint GetAllocateTrackFlags(this SequenceSoundBase sequenceSound)
        {
            Ensure.Argument.NotNull(sequenceSound);

            if (!sequenceSound.Parameters.ContainsKey(ConversionParameterNames.SequenceSound.AllocateTrackFlags))
            {
                sequenceSound.Parameters.AddValue(
                    ConversionParameterNames.SequenceSound.AllocateTrackFlags, new UIntParameterValue(uint.MaxValue));
            }

            return (uint)sequenceSound.Parameters[ConversionParameterNames.SequenceSound.AllocateTrackFlags].Value;
        }

        public static void SetAllocateTrackFlags(this SequenceSoundBase sequenceSound, uint value)
        {
            Ensure.Argument.NotNull(sequenceSound);

            if (!sequenceSound.Parameters.ContainsKey(ConversionParameterNames.SequenceSound.AllocateTrackFlags))
            {
                sequenceSound.Parameters.AddValue(
                    ConversionParameterNames.SequenceSound.AllocateTrackFlags, new UIntParameterValue());
            }

            sequenceSound.Parameters[ConversionParameterNames.SequenceSound.AllocateTrackFlags].Value = value;
        }

        /// <summary>
        /// シーケンスサウンドの部分コンバート用バイナリファイルパスを取得します。
        /// </summary>
        /// <param name="sequenceSound">シーケンスサウンドを指定します。</param>
        /// <returns>シーケンスサウンドの部分コンバート用バイナリファイルパスを返します。</returns>
        public static string GetBinaryFilePathForPartsConvert(this SequenceSoundBase sequenceSound)
        {
            Ensure.Argument.NotNull(sequenceSound);

            if (!sequenceSound.Parameters.ContainsKey(
                ConversionParameterNames.SequenceSound.BinaryFilePathForPartsConvert))
            {
                sequenceSound.Parameters.AddValue(
                    ConversionParameterNames.SequenceSound.BinaryFilePathForPartsConvert,
                    new TextParameterValue());
            }

            return sequenceSound.Parameters[
                ConversionParameterNames.SequenceSound.BinaryFilePathForPartsConvert].Value.ToString();
        }

        /// <summary>
        /// シーケンスサウンドの部分コンバート用バイナリファイルパスを設定します。
        /// </summary>
        /// <param name="sequenceSound">シーケンスサウンドを指定します。</param>
        /// <param name="value">シーケンスサウンドの部分コンバート用バイナリファイルパスを指定します。</param>
        public static void SetBinaryFilePathForPartsConvert(this SequenceSoundBase sequenceSound, string value)
        {
            Ensure.Argument.NotNull(sequenceSound);

            if (!sequenceSound.Parameters.ContainsKey(
                ConversionParameterNames.SequenceSound.BinaryFilePathForPartsConvert))
            {
                sequenceSound.Parameters.AddValue(
                    ConversionParameterNames.SequenceSound.BinaryFilePathForPartsConvert,
                    new TextParameterValue());
            }

            sequenceSound.Parameters[
                ConversionParameterNames.SequenceSound.BinaryFilePathForPartsConvert].Value = value;
        }
    }
}
