﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// ストリームサウンドファイルのファイルIDを作成します。
    /// </summary>
    internal class StreamSoundFileIDFactory : FileIDFactory<StreamSoundBase>
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="basePath">相対パスの基点となるパスを指定します。</param>
        public StreamSoundFileIDFactory(string basePath)
            : base(basePath)
        {
        }

        /// <summary>
        /// コンポーネントのファイルIDを作成します。
        /// </summary>
        /// <param name="component">コンポーネントを指定します。</param>
        /// <returns>ファイルIDを返します。</returns>
        protected override FileID CreateInternal(StreamSoundBase component)
        {
            Assertion.Argument.NotNull(component);

            if (component.Children.Count == 0)
            {
                throw new ArgumentException("internal error : stream sound has no track.");
            }

            if (component.Children.Count > 1)
            {
                return new FileID(component.Name);
            }
            else
            {
                return FileID.Create(
                    this.GetRelativeFilePath(component.Children[0]),
                    component.Parameters.GetValue(ProjectParameterNames.WaveEncoding).ToString().ToLower(),
                    component.GetTargetSampleRate(),
                    component.GetTargetChannelCount(),
                    "strm"
                    );
            }
        }
    }
}
