﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.ToolDevelopmentKit;

    public static class SoundArchiveContextUtility
    {
        public static uint GetFileID(this SoundArchiveContext context, Component component)
        {
            Assertion.Argument.NotNull(context);
            Assertion.Argument.NotNull(component);

            Component targetComponent = GetValidComponent(context, component);

            try
            {
                return context.GetFileID(
                    context.GetFile(targetComponent.GetOutputTarget())
                    );
            }
            catch (Exception exception)
            {
                throw new Exception("internal error : component file not found.", exception);
            }
        }

        public static uint GetFileID(this SoundArchiveContext context, ComponentFile file)
        {
            Assertion.Argument.NotNull(file);

            try
            {
                return (uint)context.Files.IndexOf(file);
            }
            catch (Exception exception)
            {
                throw new Exception("internal error : component file not found.", exception);
            }
        }

        private static Component GetValidComponent(SoundArchiveContext context, Component component)
        {
            if (component is WaveSoundBase && component.Parent is WaveSoundSetBase)
            {
                if (context.Traits.IsWaveSound2BinaryEnabled)
                {
                    // WaveSound2 バイナリでは、1 WSD : 1 バイナリ
                    return component;
                }
                else
                {
                    // WaveSound1 バイナリでは、1 WSDSET : 1 バイナリ
                    return component.Parent;
                }
            }
            else
            {
                return component;
            }
        }
    }
}
