﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using Projects;
    using ToolDevelopmentKit;

    internal class VelocityRegionWaveProcessorFactory : ComponentSetup<BankContext, VelocityRegion>
    {
        /// <summary>
        /// コンポーネントを処理します。
        /// </summary>
        /// <param name="context">コンバートコンテキストを指定します。</param>
        /// <param name="component">コンポーネントを指定します。</param>
        protected sealed override void RunInternal(BankContext context, VelocityRegion component)
        {
            IOutput output = component.GetOutputTarget();

            context.AddComponentProcessor(
                output,
                string.Empty,
                this.CreateProcessor(context, component, this.GetOutputItem(output))
                );
        }

        private IComponentProcessor CreateProcessor(BankContext context, VelocityRegion component, IOutputItem output)
        {
            Assertion.Argument.NotNull(component);
            return new WaveProcessor<VelocityRegion>(component, output, velocityRegion => velocityRegion.GetTargetSampleRate(), velocityRegion => velocityRegion.GetTargetChannelCount())
            {
                PreprocessExePath = context.WavePreprocessExePath,
            };
        }

        private IOutputItem GetOutputItem(IOutput output)
        {
            Assertion.Argument.NotNull(output);
            return output.ItemDictionary[string.Empty];
        }
    }
}
