﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Text;

using NintendoWare.SoundFoundation.Core;
using NintendoWare.SoundFoundation.Core.Parameters;
using NintendoWare.SoundFoundation.Projects;

namespace NintendoWare.SoundFoundation.Windows.Forms
{
    ///--------------------------------------------------------------------------
    /// <summary>
    ///
    /// </summary>
    public interface ITreeItem
    {
        ITreeItem Parent { get; set; }
        ITreeItem PreviousSibling { get; }
        ITreeItem NextSibling { get; }
        ITreeItemCollection Children { get; }

        bool Enabled { get; set; }
        bool Visible { get; set; }
        bool Expanded { get; set; }
        bool Expander { get; set; }
        bool Container { get; set; }

        int Depth { get; }
        int Length { get; set; }

        string SubItemName { get; }

        IParameterValue GetValue(string name);
        void GetConstValues(Dictionary<string, string> parameters);
    }
}
