﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.Text;

using NintendoWare.SoundFoundation.Windows.Forms.Windowless;

namespace NintendoWare.SoundFoundation.Windows.Forms
{
    public partial class NTabControl
    {
        #region ** 通常スタイル

        public class StyleTop : NWTabControlStyleTop { }

        public class StyleBottom : NWTabControlStyleBottom { }

        public class StyleLeft : NWTabControlStyleLeft { }

        public class StyleRight : NWTabControlStyleRight { }

        public class StyleMinimizableTop : NWControlStyle
        {
            public StyleMinimizableTop()
            {
                Add(typeof(NWControlHost),
                        new NWControlHostTemplateFactory(NTabControlCore.NTabControlHostTemplate.CreateInstance));
                Add(typeof(NTabControlCore),
                        new NWControlTemplateFactory(NTabControlCore.NTabControlCoreTemplateTop.CreateInstance));
                Add(typeof(NTabControlCore.NTabPanel),
                        new NWControlTemplateFactory(NTabControlCore.NTabPanelTemplateTop.CreateInstance));
                Add(typeof(NTabControlCore.NWTab),
                        new NWControlTemplateFactory(NTabControlCore.NWTabTemplateTop.CreateInstance));
            }
        }

        public class StyleMinimizableBottom : NWControlStyle
        {
            public StyleMinimizableBottom()
            {
                Add(typeof(NWControlHost),
                        new NWControlHostTemplateFactory(NTabControlCore.NTabControlHostTemplate.CreateInstance));
                Add(typeof(NTabControlCore),
                        new NWControlTemplateFactory(NTabControlCore.NTabControlCoreTemplateBottom.CreateInstance));
                Add(typeof(NTabControlCore.NTabPanel),
                        new NWControlTemplateFactory(NTabControlCore.NTabPanelTemplateBottom.CreateInstance));
                Add(typeof(NTabControlCore.NWTab),
                        new NWControlTemplateFactory(NTabControlCore.NWTabTemplateBottom.CreateInstance));
            }
        }

        public class StyleMinimizableLeft : NWControlStyle
        {
            public StyleMinimizableLeft()
            {
                Add(typeof(NWControlHost),
                        new NWControlHostTemplateFactory(NTabControlCore.NTabControlHostTemplate.CreateInstance));
                Add(typeof(NTabControlCore),
                        new NWControlTemplateFactory(NTabControlCore.NTabControlCoreTemplateLeft.CreateInstance));
                Add(typeof(NTabControlCore.NTabPanel),
                        new NWControlTemplateFactory(NTabControlCore.NTabPanelTemplateLeft.CreateInstance));
                Add(typeof(NTabControlCore.NWTab),
                        new NWControlTemplateFactory(NTabControlCore.NWTabTemplateLeft.CreateInstance));
            }
        }

        #endregion

        #region ** 最小化スタイル

        public class StyleMinimizedTop : NWControlStyle
        {
            public StyleMinimizedTop()
            {
                Add(typeof(NWControlHost),
                        new NWControlHostTemplateFactory(NTabControlCore.NTabControlHostTemplate.CreateInstance));
                Add(typeof(NTabControlCore),
                        new NWControlTemplateFactory(NTabControlCore.NTabControlCoreTemplateHorizontalMinimized.CreateInstance));
                Add(typeof(NTabControlCore.NTabPanel),
                        new NWControlTemplateFactory(NTabControlCore.NTabPanelTemplateHorizontalMinimized.CreateInstance));
                Add(typeof(NTabControlCore.NWTab),
                        new NWControlTemplateFactory(NTabControlCore.NWTabTemplateBottom.CreateInstance));
            }
        }

        public class StyleMinimizedBottom : NWControlStyle
        {
            public StyleMinimizedBottom()
            {
                Add(typeof(NWControlHost),
                        new NWControlHostTemplateFactory(NTabControlCore.NTabControlHostTemplate.CreateInstance));
                Add(typeof(NTabControlCore),
                        new NWControlTemplateFactory(NTabControlCore.NTabControlCoreTemplateHorizontalMinimized.CreateInstance));
                Add(typeof(NTabControlCore.NTabPanel),
                        new NWControlTemplateFactory(NTabControlCore.NTabPanelTemplateHorizontalMinimized.CreateInstance));
                Add(typeof(NTabControlCore.NWTab),
                        new NWControlTemplateFactory(NTabControlCore.NWTabTemplateTop.CreateInstance));
            }
        }

        public class StyleMinimizedLeft : NWControlStyle
        {
            public StyleMinimizedLeft()
            {
                Add(typeof(NWControlHost),
                        new NWControlHostTemplateFactory(NTabControlCore.NTabControlHostTemplate.CreateInstance));
                Add(typeof(NTabControlCore),
                        new NWControlTemplateFactory(NTabControlCore.NTabControlCoreTemplateVerticalMinimized.CreateInstance));
                Add(typeof(NTabControlCore.NTabPanel),
                        new NWControlTemplateFactory(NTabControlCore.NTabPanelTemplateVerticalMinimized.CreateInstance));
                Add(typeof(NTabControlCore.NWTab),
                        new NWControlTemplateFactory(NTabControlCore.NWTabTemplateRight.CreateInstance));
            }
        }

        public class StyleMinimizedRight : NWControlStyle
        {
            public StyleMinimizedRight()
            {
                Add(typeof(NWControlHost),
                        new NWControlHostTemplateFactory(NTabControlCore.NTabControlHostTemplate.CreateInstance));
                Add(typeof(NTabControlCore),
                        new NWControlTemplateFactory(NTabControlCore.NTabControlCoreTemplateVerticalMinimized.CreateInstance));
                Add(typeof(NTabControlCore.NTabPanel),
                        new NWControlTemplateFactory(NTabControlCore.NTabPanelTemplateVerticalMinimized.CreateInstance));
                Add(typeof(NTabControlCore.NWTab),
                        new NWControlTemplateFactory(NTabControlCore.NWTabTemplateLeft.CreateInstance));
            }
        }

        #endregion
    }
}
