﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundFoundation.Windows.Forms
{
    public class ComponentHeaderAdapter : IHeaderSource
    {
        private ComponentHeaderItemCollection _Headers = null;

        public event EventHandler Updated;

        public ComponentHeaderAdapter()
        {
            _Headers = new ComponentHeaderItemCollection();
            _Headers.CollectionChanged += new NotifyCollectionChangedEventHandler(Update);
        }

        public ComponentHeaderItemCollection Headers
        {
            get
            {
                return _Headers;
            }
        }

        public System.Windows.Forms.SortOrder SortOrder
        {
            get; set;
        }

        public IHeaderItem SortItem
        {
            get; set;
        }

        //IHeaderItemCollection IHeaderSource.Items {
        public IHeaderItemCollection Items
        {
            get
            {
                return this.Headers;
            }
        }

        private void OnUpdated(NotifyCollectionChangedEventArgs e)
        {
            if (Updated != null)
            {
                Updated(this, e);
            }
        }

        private void Update(object sender, NotifyCollectionChangedEventArgs e)
        {
            OnUpdated(e);
        }
    }
}
