﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;

namespace NintendoWare.SoundFoundation.Windows.CommandBars
{
    /// <summary>
    /// コマンドバーポップアップアイテムの情報を管理します。
    /// </summary>
    public class CommandBarPopupItem : CommandBarItem
    {
        private string _text = string.Empty;     // テキスト

        // 子グループコレクション
        private CommandBarItemGroupCollection _groups = new CommandBarItemGroupCollection();

        public CommandBarPopupItem(string uri) : base(uri) { }

        /// <summary>
        /// ローカライズされたテキストを取得します。
        /// </summary>
        public override string Text
        {
            get { return _text; }
            set
            {
                if (null == value) { throw new ArgumentNullException("value"); }
                _text = value;
            }
        }

        /// <summary>
        /// 子グループコレクションを取得します。
        /// </summary>
        public CommandBarItemGroupCollection Groups
        {
            get { return _groups; }
        }

        /// <summary>
        /// URI からアイテムを検索します。
        /// </summary>
        /// <param name="uri">アイテムの URI。</param>
        /// <returns>該当するアイテム。</returns>
        public override IEnumerable<CommandBarItem> FindItems(string uri)
        {
            return from CommandBarItemGroup itemGroup in _groups
                   from CommandBarItem item in itemGroup.FindItems(uri)
                   select item;
        }
    }
}
