﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundFoundation.Utilities
{
    public class EnvironmentUtility
    {
        /// <summary>
        ///
        /// </summary>
        public static void RemoveMultipleEnvironmentVariables()
        {
            RemoveMultipleEnvironmentVariableWorkaround("tmp");
            RemoveMultipleEnvironmentVariableWorkaround("temp");
        }

        /// <summary>
        /// cygwin の仕様変更によって、1.7.10 以降の bash からツールが実行された場合、
        /// tmp と TMP など大文字・小文字違いの同名
        /// 環境変数が定義され、XmlSerializer内部で例外が発生してしまう問題があります。
        /// 対策として、小文字の環境変数を削除します。
        /// </summary>
        private static void RemoveMultipleEnvironmentVariableWorkaround(string envName)
        {
            // 環境変数を取得する。
            string envVal = Environment.GetEnvironmentVariable(envName);
            if (string.IsNullOrEmpty(envVal))
            {
                return;
            }

            // 手始めに一つ削除して、その後再度取得してみる。
            Environment.SetEnvironmentVariable(envName, null);
            string envVal2 = Environment.GetEnvironmentVariable(envName);
            if (!string.IsNullOrEmpty(envVal2))
            {
                // 2つ目が取得できた場合は、多重定義されている状況。
                // POSIX スタイルの環境変数を削除するようにする。
                if (envVal2.StartsWith("/"))
                {
                    Environment.SetEnvironmentVariable(envName, envVal);
                }
                return;
            }
            else
            {
                // 多重定義がなかったので、削除した環境変数を元に元しておく。
                Environment.SetEnvironmentVariable(envName, envVal);
            }
        }
    }
}
