﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System.Text.RegularExpressions;
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Resources;
    using ToolDevelopmentKit;

    /// <summary>
    /// アイテムの名前を検証します。
    /// </summary>
    public static class ItemNameValidator
    {
        public static readonly Regex InvalidCharsRegex = new Regex("[^0-9a-zA-Z_]");


        /// <summary>
        /// サウンドプロジェクトアイテムの名前を検証します。
        /// </summary>
        /// <param name="name">サウンドプロジェクトアイテムの名前。</param>
        /// <returns>検証結果。</returns>
        public static ValidationResult ValidateSoundProjectItemName(string name)
        {
            Ensure.Argument.NotNull(name);

            if (name.Length == 0)
            {
                return new ValidationResult(false, MessageResource.Message_InvalidSoundProjectItemName);
            }

            if (!new Regex("^[a-zA-Z_][0-9a-zA-Z_]*$").IsMatch(name))
            {
                return new ValidationResult(false, MessageResource.Message_InvalidSoundProjectItemName);
            }

            return ValidationResult.NoError;
        }
    }
}
