﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using NintendoWare.SoundFoundation.Core.Parameters;
    using NintendoWare.ToolDevelopmentKit;

    public class Sound3DParameterValue : ComplexParameterValue<Sound3D>
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public Sound3DParameterValue()
            : this(new Sound3D())
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="value">パラメータの値を指定します。</param>
        public Sound3DParameterValue(Sound3D value)
            : base(value)
        {
            SetParameterAttributes(Sound3D.PropertyNameDecayCurve3D, ParameterAttributes.ComputeSndeditTransferHash);
            SetParameterAttributes(Sound3D.PropertyNameDecayRatio3D, ParameterAttributes.ComputeSndeditTransferHash);
            SetParameterAttributes(Sound3D.PropertyNameDopplerFactor3D, ParameterAttributes.ComputeSndeditTransferHash);
            SetParameterAttributes(Sound3D.PropertyNameEnable3DVolume, ParameterAttributes.ComputeSndeditTransferHash);
            SetParameterAttributes(Sound3D.PropertyNameEnable3DPan, ParameterAttributes.ComputeSndeditTransferHash);
            SetParameterAttributes(Sound3D.PropertyNameEnable3DSurroundPan, ParameterAttributes.ComputeSndeditTransferHash);
            SetParameterAttributes(Sound3D.PropertyNameEnable3DPriority, ParameterAttributes.ComputeSndeditTransferHash);
            SetParameterAttributes(Sound3D.PropertyNameEnable3DFilter, ParameterAttributes.ComputeSndeditTransferHash);
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// DecayCurve3D を取得または設定します。
        /// </summary>
        public DecayCurve3DParameterValue DecayCurve3D
        {
            get { return this.Parameters[Sound3D.PropertyNameDecayCurve3D] as DecayCurve3DParameterValue; }
        }

        /// <summary>
        /// DecayRatio3D を取得または設定します。
        /// </summary>
        public DoubleParameterValue DecayRatio3D
        {
            get { return this.Parameters[Sound3D.PropertyNameDecayRatio3D] as DoubleParameterValue; }
        }

        /// <summary>
        /// DopplerFactor3D を取得または設定します。
        /// </summary>
        public IntParameterValue DopplerFactor3D
        {
            get { return this.Parameters[Sound3D.PropertyNameDopplerFactor3D] as IntParameterValue; }
        }

        /// <summary>
        /// Enable3DFilter を取得または設定します。
        /// </summary>
        public BoolParameterValue Enable3DFilter
        {
            get { return this.Parameters[Sound3D.PropertyNameEnable3DFilter] as BoolParameterValue; }
        }

        /// <summary>
        /// Enable3DPan を取得または設定します。
        /// </summary>
        public BoolParameterValue Enable3DPan
        {
            get { return this.Parameters[Sound3D.PropertyNameEnable3DPan] as BoolParameterValue; }
        }

        /// <summary>
        /// Enable3DPriority を取得または設定します。
        /// </summary>
        public BoolParameterValue Enable3DPriority
        {
            get { return this.Parameters[Sound3D.PropertyNameEnable3DPriority] as BoolParameterValue; }
        }

        /// <summary>
        /// Enable3DSurroundPan を取得または設定します。
        /// </summary>
        public BoolParameterValue Enable3DSurroundPan
        {
            get { return this.Parameters[Sound3D.PropertyNameEnable3DSurroundPan] as BoolParameterValue; }
        }

        /// <summary>
        /// Enable3DVolume を取得または設定します。
        /// </summary>
        public BoolParameterValue Enable3DVolume
        {
            get { return this.Parameters[Sound3D.PropertyNameEnable3DVolume] as BoolParameterValue; }
        }

        /// <summary>
        /// XML シリアライズ時の要素名を取得します。
        /// </summary>
        protected override string XmlElementName
        {
            get
            {
                return ProjectParameterNames.Sound.Sound3DParams;
            }
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// パラメータの値を取得するキャストオペレータです。
        /// </summary>
        /// <param name="value">対象となるパラメータ値を指定します。</param>
        /// <returns>パラメータの値を返します。</returns>
        public static implicit operator Sound3D(Sound3DParameterValue value)
        {
            Ensure.Argument.NotNull(value);
            return value.Value;
        }
    }
}
