﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.ComponentModel;
    using Core.Parameters;
    using ToolDevelopmentKit;

    public class Sends : INotifyPropertyChanged, ICloneable
    {
        private const string PropertyNameMainSend = nameof(ProjectParameterNames.Sends.MainSend);
        private const string PropertyNameAuxASend = nameof(ProjectParameterNames.Sends.AuxASend);
        private const string PropertyNameAuxBSend = nameof(ProjectParameterNames.Sends.AuxBSend);

        private int mainSend = 127;
        private int auxASend = 0;
        private int auxBSend = 0;

        /// <summary>
        /// プロパティ値が変更されたときに発生します。
        /// </summary>
        public event PropertyChangedEventHandler PropertyChanged;

        public Sends()
        {
        }

        /// <summary>
        ///
        /// </summary>
        public virtual ICloneable Clone()
        {
            Sends sends = new Sends();

            sends.MainSend = this.MainSend;
            sends.AuxASend = this.AuxASend;
            sends.AuxBSend = this.AuxBSend;

            return sends;
        }

        object ICloneable.Clone()
        {
            return this.Clone();
        }

        [ValueRange(0, 127)]
        public int MainSend
        {
            get { return this.mainSend; }
            set
            {
                if (this.mainSend == value)
                {
                    return;
                }

                this.mainSend = value;
                this.OnNotifyPropertyChanged(new PropertyChangedEventArgs(PropertyNameMainSend));
            }
        }

        [ValueRange(0, 127)]
        public int AuxASend
        {
            get { return this.auxASend; }
            set
            {
                if (this.auxASend == value)
                {
                    return;
                }

                this.auxASend = value;
                this.OnNotifyPropertyChanged(new PropertyChangedEventArgs(PropertyNameAuxASend));
            }
        }

        [ValueRange(0, 127)]
        public int AuxBSend
        {
            get { return this.auxBSend; }
            set
            {
                if (this.auxBSend == value)
                {
                    return;
                }

                this.auxBSend = value;
                this.OnNotifyPropertyChanged(new PropertyChangedEventArgs(PropertyNameAuxBSend));
            }
        }

        /// <summary>
        /// プロパティ値が変更されたときに発生します。
        /// </summary>
        /// <param name="e">イベントパラメータを指定します。</param>
        protected void OnNotifyPropertyChanged(PropertyChangedEventArgs e)
        {
            Assertion.Argument.NotNull(e);

            if (this.PropertyChanged != null)
            {
                this.PropertyChanged(this, e);
            }
        }
    }
}
