﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Core.Parameters;

    public class PitchParameterValue : FloatParameterValue
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="value">パラメータの値を指定します。</param>
        /// <param name="min">最小値を指定します。</param>
        /// <param name="max">最大値を指定します。</param>
        public PitchParameterValue(float value, float min, float max)
            : base(value, min, max)
        {
        }

        /// <summary>
        /// 指定した値を検証します。補正するので常に NoError
        /// </summary>
        /// <param name="value">検証する値を指定します。</param>
        /// <returns>検証結果を返します。</returns>
        protected override ValidationResult ValidateInternal(float value)
        {
            return ValidationResult.NoError;
        }

        /// <summary>
        /// パラメータ値を取得または設定します。
        /// </summary>
        public override float Value
        {
            get { return base.Value; }
            set
            {
                if (value < this.MinValue)
                {
                    value = this.MinValue;
                }
                else if (this.MaxValue < value)
                {
                    value = this.MaxValue;
                }

                base.Value = value;
            }
        }
    }
}
