﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using NintendoWare.SoundFoundation.Core.Parameters;
using NintendoWare.SoundFoundation.Core;
using NintendoWare.SoundFoundation.Resources;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System;
using NintendoWare.ToolDevelopmentKit;

namespace NintendoWare.SoundFoundation.Projects
{
    /// <summary>
    /// IntegratedLoudnessStatus 型のパラメータ値を格納します。
    /// </summary>
    public class IntegratedLoudnessStatusParameterValue : ParameterValue<IntegratedLoudnessStatus>
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public IntegratedLoudnessStatusParameterValue()
            : this(IntegratedLoudnessStatus.Unmeasured)
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="value">パラメータ値を指定します。</param>
        public IntegratedLoudnessStatusParameterValue(IntegratedLoudnessStatus value)
            : base(value)
        {
        }

        /// <summary>
        /// パラメータの値からテキストを取得します。
        /// </summary>
        /// <returns>テキストを返します。</returns>
        public override string ToString()
        {
            switch (this.Value)
            {
                case IntegratedLoudnessStatus.Unmeasured:
                    return MessageResource.Label_IntegratedLoudnessStatus_Unmeasured;

                case IntegratedLoudnessStatus.WaitingMeasure:
                    return MessageResource.Label_IntegratedLoudnessStatus_WaitingMeasure;

                case IntegratedLoudnessStatus.Measuring:
                    return MessageResource.Label_IntegratedLoudnessStatus_Measuring;

                case IntegratedLoudnessStatus.Measured:
                    return MessageResource.Label_IntegratedLoudnessStatus_Measured;

                case IntegratedLoudnessStatus.Error:
                    return MessageResource.Label_IntegratedLoudnessStatus_Error;
            }

            Debug.Assert(false, "An unexpected value");
            return String.Empty;
        }

        /// <summary>
        /// テキストからパラメータ値を取得します。
        /// </summary>
        /// <param name="text">テキストを指定します。</param>
        protected override IntegratedLoudnessStatus ParseInternal(string text)
        {
            Ensure.Argument.NotNull(text);

            if (text == MessageResource.Label_IntegratedLoudnessStatus_Unmeasured)
            {
                return IntegratedLoudnessStatus.Unmeasured;
            }
            else if (text == MessageResource.Label_IntegratedLoudnessStatus_WaitingMeasure)
            {
                return IntegratedLoudnessStatus.WaitingMeasure;
            }
            else if (text == MessageResource.Label_IntegratedLoudnessStatus_Measuring)
            {
                return IntegratedLoudnessStatus.Measuring;
            }
            else if (text == MessageResource.Label_IntegratedLoudnessStatus_Measured)
            {
                return IntegratedLoudnessStatus.Measured;
            }
            else if (text == MessageResource.Label_IntegratedLoudnessStatus_Error)
            {
                return IntegratedLoudnessStatus.Error;
            }

            throw new ArgumentException("invalid text.");
        }

        /// <summary>
        /// パラメータの値を取得するキャストオペレータです。
        /// </summary>
        /// <param name="value">対象となるパラメータ値を指定します。</param>
        /// <returns>パラメータの値を返します。</returns>
        public static implicit operator IntegratedLoudnessStatus(IntegratedLoudnessStatusParameterValue value)
        {
            Ensure.Argument.NotNull(value);
            return value.Value;
        }

        /// <summary>
        /// 指定した値を検証します。
        /// </summary>
        /// <param name="value">検証する値を指定します。</param>
        /// <returns>検証結果を返します。</returns>
        protected override ValidationResult ValidateInternal(IntegratedLoudnessStatus value)
        {
            return ValidationResult.NoError;
        }

        /// <summary>
        /// パラメータ値のバイト列を取得します。
        /// </summary>
        /// <returns>バイト列の列挙子を返します。</returns>
        protected override IEnumerable<byte> GetBytes()
        {
            return BitConverter.GetBytes((int)this.Value);
        }
    }
}
