﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;

    public class UserParameterStructure : ICloneable
    {
        public int Location { get; set; }
        public int Size { get; set; }
        public StructureTypes StructureType { get; set; }
        public string Label { get; set; }
        public string ValueCandidate { get; set; }
        public bool ShowColumn { get; set; }

        public UserParameterStructure()
        {
            Size = 1;
            ShowColumn = true;
            StructureType = StructureTypes.UInteger;
        }

        public object Clone()
        {
            UserParameterStructure data = new UserParameterStructure();

            data.Location = this.Location;
            data.Size = this.Size;
            data.StructureType = this.StructureType;
            data.Label = this.Label;
            data.ValueCandidate = this.ValueCandidate;
            data.ShowColumn = this.ShowColumn;

            return data;
        }

        public void CopyFrom(UserParameterStructure data)
        {
            this.Location = data.Location;
            this.Size = data.Size;
            this.StructureType = data.StructureType;
            this.Label = data.Label;
            this.ValueCandidate = data.ValueCandidate;
            this.ShowColumn = data.ShowColumn;
        }

        public override int GetHashCode()
        {
            return base.GetHashCode();
        }

        public override bool Equals(object obj)
        {
            if (!(obj is UserParameterStructure))
            {
                return false;
            }

            UserParameterStructure data = obj as UserParameterStructure;
            if (this.Label != data.Label ||
                this.StructureType != data.StructureType ||
                this.Location != data.Location ||
                this.Size != data.Size ||
                this.ValueCandidate != data.ValueCandidate)
            {
                return false;
            }

            return true;
        }
    }
}
