﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Collections.Generic;

    public class ListOutput : ICloneable
    {
        public ListOutput()
        {
            this.Name = string.Empty;
            this.IsOutput = false;
            this.ColumnOutputs = new List<ListColumnOutput>();
        }

        public string Name { get; set; }

        public bool IsOutput { get; set; }

        public IList<ListColumnOutput> ColumnOutputs { get; private set; }

        /// <summary>
        /// インスタンスのコピーを作成します。
        /// </summary>
        /// <returns>コピーされた新しいオブジェクトを返します。</returns>
        public ListOutput Clone()
        {
            ListOutput clone = new ListOutput()
            {
                Name = string.Copy(this.Name),
                IsOutput = this.IsOutput,
            };

            foreach (ListColumnOutput value in this.ColumnOutputs)
            {
                clone.ColumnOutputs.Add(value.Clone());
            }

            return clone;
        }

        /// <summary>
        /// 値を比較します。
        /// </summary>
        public override bool Equals(Object obj)
        {
            if (obj is ListOutput)
            {
                ListOutput other = obj as ListOutput;

                if (this.Name != other.Name ||
                    this.IsOutput != other.IsOutput ||
                    this.ColumnOutputs.Count != other.ColumnOutputs.Count)
                {
                    return false;
                }
                for (int i = 0; i < this.ColumnOutputs.Count; i++)
                {
                    if (this.ColumnOutputs[i].Equals(other.ColumnOutputs[i]) == false)
                    {
                        return false;
                    }
                }
                return true;
            }
            else
            {
                return false;
            }
        }

        public override int GetHashCode()
        {
            return base.GetHashCode();
        }

        /// <summary>
        /// インスタンスのコピーを作成します。
        /// </summary>
        /// <returns>コピーされた新しいオブジェクトを返します。</returns>
        object ICloneable.Clone()
        {
            return this.Clone();
        }
    }
}
