﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Diagnostics;
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Core.Parameters;

    public static class PanCurveEx
    {
        public static string ToText(this PanCurve value)
        {
            switch (value)
            {
                case PanCurve.Linear:
                    return "Linear(-6dB)";

                case PanCurve.Linear_0Db:
                    return "Linear(0dB)";

                case PanCurve.Linear_0Db_Clamp:
                    return "Linear(0dB,clamp)";

                case PanCurve.SinCos:
                    return "Sin/Cos(-3dB)";

                case PanCurve.SinCos_0Db:
                    return "Sin/Cos(0dB)";

                case PanCurve.SinCos_0Db_Clamp:
                    return "Sin/Cos(0dB,clamp)";

                case PanCurve.Sqrt:
                    return "Sqrt(-3dB)";

                case PanCurve.Sqrt_0Db:
                    return "Sqrt(0dB)";

                case PanCurve.Sqrt_0Db_Clamp:
                    return "Sqrt(0dB,clamp)";
            }

            Debug.Assert(false, "An unexpected value");
            return String.Empty;
        }

        public static PanCurve Parse(string text)
        {
            if (null == text) { throw new ArgumentNullException("text"); }

            switch (text)
            {
                case "Linear(-6dB)":
                    return PanCurve.Linear;

                case "Linear(0dB)":
                    return PanCurve.Linear_0Db;

                case "Linear(0dB,clamp)":
                    return PanCurve.Linear_0Db_Clamp;

                case "Sin/Cos(-3dB)":
                    return PanCurve.SinCos;

                case "Sin/Cos(0dB)":
                    return PanCurve.SinCos_0Db;

                case "Sin/Cos(0dB,clamp)":
                    return PanCurve.SinCos_0Db_Clamp;

                case "Sqrt(-3dB)":
                    return PanCurve.Sqrt;

                case "Sqrt(0dB)":
                    return PanCurve.Sqrt_0Db;

                case "Sqrt(0dB,clamp)":
                    return PanCurve.Sqrt_0Db_Clamp;
            }

            throw new ArgumentException("invalid text.");
        }
    }
}
