﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Diagnostics;
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Core.Parameters;

    public static class GroupItemRegisterTypeEx
    {
        public static string ToText(this GroupItemRegisterType value)
        {
            switch (value)
            {
                case GroupItemRegisterType.All:
                    return "All";

                case GroupItemRegisterType.SequenceAndBank:
                    return "SequenceAndBank";

                case GroupItemRegisterType.SequenceAndWaveArchive:
                    return "SequenceAndWaveArchive";

                case GroupItemRegisterType.BankAndWaveArchive:
                    return "BankAndWaveArchive";

                case GroupItemRegisterType.OnlySequence:
                    return "OnlySequence";

                case GroupItemRegisterType.OnlyWaveSoundSet:
                    return "OnlyWaveSoundSet";

                case GroupItemRegisterType.OnlyBank:
                    return "OnlyBank";

                case GroupItemRegisterType.OnlyWaveArchive:
                    return "OnlyWaveArchive";

            }

            Debug.Assert(false, "An unexpected value");
            return String.Empty;
        }

        public static GroupItemRegisterType Parse(string text)
        {
            if (null == text) { throw new ArgumentNullException("text"); }

            switch (text)
            {
                case "All":
                    return GroupItemRegisterType.All;

                case "SequenceAndBank":
                    return GroupItemRegisterType.SequenceAndBank;

                case "SequenceAndWaveArchive":
                    return GroupItemRegisterType.SequenceAndWaveArchive;

                case "BankAndWaveArchive":
                    return GroupItemRegisterType.BankAndWaveArchive;

                case "OnlySequence":
                    return GroupItemRegisterType.OnlySequence;

                case "OnlyWaveSoundSet":
                    return GroupItemRegisterType.OnlyWaveSoundSet;

                case "OnlyBank":
                    return GroupItemRegisterType.OnlyBank;

                case "OnlyWaveArchive":
                    return GroupItemRegisterType.OnlyWaveArchive;
            }

            throw new ArgumentException("invalid text.");
        }

        public static bool AllIncludes(this GroupItemRegisterType loadType)
        {
            return loadType == GroupItemRegisterType.All;
        }

        public static bool SequenceIncludes(this GroupItemRegisterType loadType)
        {
            return loadType.AllIncludes() ||
                loadType == GroupItemRegisterType.SequenceAndWaveArchive ||
                loadType == GroupItemRegisterType.SequenceAndBank ||
                loadType == GroupItemRegisterType.OnlySequence;
        }

        public static bool BankIncludes(this GroupItemRegisterType loadType)
        {
            return loadType.AllIncludes() ||
                loadType == GroupItemRegisterType.SequenceAndBank ||
                loadType == GroupItemRegisterType.BankAndWaveArchive ||
                loadType == GroupItemRegisterType.OnlyBank;
        }

        public static bool WaveSoundSetIncludes(this GroupItemRegisterType loadType)
        {
            return loadType.AllIncludes() ||
                loadType == GroupItemRegisterType.OnlyWaveSoundSet;
        }

        public static bool WaveArchiveIncludes(this GroupItemRegisterType loadType)
        {
            return loadType.AllIncludes() ||
                loadType == GroupItemRegisterType.SequenceAndWaveArchive ||
                loadType == GroupItemRegisterType.BankAndWaveArchive ||
                loadType == GroupItemRegisterType.OnlyWaveArchive;
        }

        public static bool BankAndWaveArchiveIncludes(this GroupItemRegisterType loadType)
        {
            return loadType.AllIncludes() ||
                loadType == GroupItemRegisterType.BankAndWaveArchive;
        }

        public static bool WaveSoundSetAndWaveArchiveIncludes(this GroupItemRegisterType loadType)
        {
            return loadType.AllIncludes();
        }

        public static bool IsValidForSequence(this GroupItemRegisterType loadType)
        {
            switch (loadType)
            {
                case GroupItemRegisterType.All:
                case GroupItemRegisterType.SequenceAndBank:
                case GroupItemRegisterType.SequenceAndWaveArchive:
                case GroupItemRegisterType.OnlySequence:
                case GroupItemRegisterType.BankAndWaveArchive:
                case GroupItemRegisterType.OnlyBank:
                case GroupItemRegisterType.OnlyWaveArchive:
                    return true;
            }

            return false;
        }

        public static bool IsValidForBank(this GroupItemRegisterType loadType)
        {
            switch (loadType)
            {
                case GroupItemRegisterType.All:
                case GroupItemRegisterType.BankAndWaveArchive:
                case GroupItemRegisterType.OnlyBank:
                case GroupItemRegisterType.OnlyWaveArchive:
                    return true;
            }

            return false;
        }

        public static bool IsValidForWaveSoundSet(this GroupItemRegisterType loadType)
        {
            switch (loadType)
            {
                case GroupItemRegisterType.All:
                case GroupItemRegisterType.OnlyWaveSoundSet:
                case GroupItemRegisterType.OnlyWaveArchive:
                    return true;
            }

            return false;
        }

        public static bool IsValidForWaveArchive(this GroupItemRegisterType loadType)
        {
            switch (loadType)
            {
                case GroupItemRegisterType.All:
                case GroupItemRegisterType.OnlyWaveArchive:
                    return true;
            }

            return false;
        }
    }
}
