﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.ToolDevelopmentKit;

    public class DocumentImportServiceTraits
    {
        public IObjectFactory<ImporterKey, IDocumentImporter> ImporterFactory { get; set; }

        public struct ImporterKey
        {
            private readonly string sourceDocumentTypeName;
            private readonly string destinationDocumentTypeName;

            public ImporterKey(
                string sourceDocumentTypeName,
                string destinationDocumentTypeName)
            {
                Ensure.Argument.StringNotEmpty(sourceDocumentTypeName);
                Ensure.Argument.StringNotEmpty(destinationDocumentTypeName);

                this.sourceDocumentTypeName = sourceDocumentTypeName;
                this.destinationDocumentTypeName = destinationDocumentTypeName;
            }

            public string SourceDocumentTypeName
            {
                get { return this.sourceDocumentTypeName; }
            }

            public string DestinationDocumentTypeName
            {
                get { return this.destinationDocumentTypeName; }
            }
        }
    }
}
