﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace NintendoWare.SoundFoundation.Projects
{
    /// <summary>
    /// サウンドプロジェクトコンバート警告フラグ
    /// </summary>
    [Flags]
    public enum SoundProjectConvertWarningFlags : uint
    {
        /// <summary>
        /// 全ての警告を無効にする
        /// </summary>
        NoWarning = 0x00000000,

        /// <summary>
        /// 参照されないアイテムがあれば警告する
        /// </summary>
        WarnUnreferencedItem = 0x00000001,

        /// <summary>
        /// グループに登録されていないアイテムがあれば警告する
        /// </summary>
        WarnIndependentItem = 0x00000002,

        /// <summary>
        /// 全ての警告を有効にする
        /// </summary>
        WarnAll = 0xffffffff,
    }
}
