﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation
{
    /// <summary>
    /// プラットフォーム情報を管理します。
    /// </summary>
    public class Platforms
    {
        /// <summary>
        /// 過去プラットフォーム (Rvl / Ctr / Cafe) を除く、すべてのプラットフォームを示します。
        /// </summary>
        public class Any
        {
            public const string PlatformName = "Any";

            public const string SoundProjectDocument = "NW SoundProject Document " + SoundProjectDocumentVersion;
            public const string SoundSetDocument = "NW SoundSet Document " + SoundSetDocumentVersion;
            public const string BankDocument = "NW Bank Document " + BankDocumentVersion;
            public const string TextSequenceSoundDocument = "NW TextSequenceSound Document";

            public const string SoundProjectDocumentVersion = "1.5.0.0";
            public const string SoundSetDocumentVersion = "1.2.0.0";
            public const string BankDocumentVersion = "1.2.0.0";
        }

        public class Rvl
        {
            public const string SoundProjectDocument = "NW4R SoundProject LegacyDocument";
            public const string SoundSetDocument = "NW4R SoundSet LegacyDocument";
            public const string BankDocument = "NW4R Bank LegacyDocument";
        }

        public class Ctr
        {
            public const string PlatformName = "Ctr";

            public const string SoundProjectDocument = "NW4C SoundProject Document " + SoundProjectDocumentVersion;
            public const string SoundSetDocument = "NW4C SoundSet Document " + SoundSetDocumentVersion;
            public const string BankDocument = "NW4C Bank Document " + BankDocumentVersion;

            public const string SoundProjectDocumentVersion = "1.6.0.0";
            public const string SoundSetDocumentVersion = "1.2.0.0";
            public const string BankDocumentVersion = "1.0.0.0";
        }

        public class Cafe
        {
            public const string PlatformName = "Cafe";

            public const string SoundProjectDocument = "NW4F SoundProject Document " + SoundProjectDocumentVersion;
            public const string SoundSetDocument = "NW4F SoundSet Document " + SoundSetDocumentVersion;
            public const string BankDocument = "NW4F Bank Document " + BankDocumentVersion;

            public const string SoundProjectDocumentVersion = "9.9.9.9";
            public const string SoundSetDocumentVersion = "9.9.9.9";
            public const string BankDocumentVersion = "9.9.9.9";
        }
    }
}
