﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.ObjectModel;
using System.Diagnostics;

namespace NintendoWare.SoundFoundation.Operations
{
    /// <summary>
    /// オペレーションを自由に登録可能なトランザクションです。
    /// </summary>
    public class UserTransaction : Transaction
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public UserTransaction() { }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="description">トランザクションの説明。</param>
        public UserTransaction(string description) : base(description) { }

        public new OperationCollection Operations
        {
            get { return OperationsInternal; }
        }
    }
}
