﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace NintendoWare.SoundFoundation.Operations
{
    /// <summary>
    /// オペレーションの基本クラスです。
    /// </summary>
    public abstract class Operation
    {
        /// <summary>
        /// オペレーションが実行されたかどうかを取得します。
        /// </summary>
        public abstract bool IsExecuted { get; }

        /// <summary>
        /// オペレーションを実行します。
        /// </summary>
        /// <returns>処理された場合は true、処理できなかった場合は false。</returns>
        public abstract bool Execute();

        /// <summary>
        /// オペレーションをロールバックします。
        /// </summary>
        /// <returns>処理された場合は true、処理できなかった場合は false。</returns>
        public abstract bool Rollback();

        /// <summary>
        /// 現在、オペレーションを実行可能かどうかを取得します。
        /// </summary>
        /// <returns>実行可能な場合は true、実行不可能な場合は false。</returns>
        public abstract bool CanExecute();

        /// <summary>
        /// 現在、オペレーションをロールバック可能かどうかを取得します。
        /// </summary>
        /// <returns>ロールバック可能な場合は true、ロールバック不可能な場合は false。</returns>
        public abstract bool CanRollback();
    }
}
