﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Logs
{
    using Projects;

    public class ErrorLine : OutputLine
    {
        public ErrorLine(string text)
            : base(OutputLevel.Error, text)
        {
        }

        public ErrorLine(string text, Component component)
            : base(OutputLevel.Error, text, component)
        {
        }

        public ErrorLine(string text, params Component[] components)
            : base(OutputLevel.Error, text, components)
        {
        }

        protected override string Header
        {
            get
            {
                string targetComponentName = this.GetTargetComponentName();

                if (targetComponentName.Length == 0)
                {
                    return Resources.MessageResource.MessageHeader_Error_General;
                }

                return string.Format(
                    Resources.MessageResource.MessageHeader_Error_GeneralWithName,
                    targetComponentName);
            }
        }
    }
}
