﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using System.Collections.Generic;
    using System.Xml;
    using System.Xml.Serialization;
    using ToolDevelopmentKit.Conversion;

    [Serializable]
    [XmlRoot("SoundProject", Namespace = XmlNamespaces.Base, IsNullable = false)]
    [NamedProperty("SoundProject")]
    public class XmlSoundProject
    {
        [XmlArray("ProjectSoundSets")]
        [XmlArrayItem("ProjectSoundSet", Type = typeof(XmlProjectSoundSet))]
        public List<XmlProjectSoundSet> ProjectSoundSets { get; set; }

        [XmlElement("ProjectSoundSetRoot")]
        public XmlProjectSoundSetRoot ProjectSoundSetRoot { get; set; }

        [XmlElement("SoundArchivePlayer")]
        public XmlSoundArchivePlayer SoundArchivePlayer { get; set; }

        [XmlElement("Convert")]
        public XmlConvert Convert { get; set; }

        [XmlElement("ItemNaming")]
        public XmlItemNaming ItemNaming { get; set; }

        [XmlElement("CommentColumnText")]
        public XmlCommentColumnText CommentColumnText { get; set; }

        [XmlElement("ColorComment")]
        public XmlColorComment ColorComment { get; set; }

        [XmlArray("UserCommands")]
        [XmlArrayItem("UserCommand", Type = typeof(XmlUserCommand))]
        public List<XmlUserCommand> UserCommands { get; set; }

        [XmlArray("SoundListOutputs")]
        [XmlArrayItem("SoundListOutput", Type = typeof(XmlSoundListOutput))]
        public List<XmlSoundListOutput> SoundListOutputs { get; set; }

        [XmlArray("UserParameterSettings")]
        [XmlArrayItem("UserParameterSetting", Type = typeof(XmlUserParameterSetting))]
        public List<XmlUserParameterSetting> UserParameterSettings { get; set; }

        [XmlElement("ProjectSetting")]
        public XmlProjectSetting ProjectSetting { get; set; }

        [XmlElement("FileEvent")]
        public XmlFileEvent FileEvent { get; set; }

        [XmlElement("SndEdit")]
        public XmlSndEdit SndEdit { get; set; }

        [XmlElement("Connection")]
        public XmlConnection Connection { get; set; }

        [XmlElement("Statistics")]
        public XmlStatistics Statistics { get; set; }

        [XmlArray("SoundArchiveSettings")]
        [XmlArrayItem("SoundArchiveSetting", Type = typeof(XmlSoundArchiveSetting))]
        public List<XmlSoundArchiveSetting> SoundArchiveSettings { get; set; }
    }
}
