﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Xml;
    using System.Xml.Serialization;

    [Serializable]
    [XmlRoot("Convert", Namespace = XmlNamespaces.Base, IsNullable = false)]
    public class XmlConvert : IXmlParameterProvider
    {
        [XmlArray("Parameters")]
        // コンバートパラメータ
        [XmlArrayItem(XmlParameterNames.Conversion.DoWarnUnreferencedItems, Type = typeof(XmlDoWarnUnreferencedItemsParam))]
        [XmlArrayItem(XmlParameterNames.Conversion.DoWarnDisableGroupItemTargets, Type = typeof(XmlDoWarnDisableGroupItemTargetsParam))]
        [XmlArrayItem(XmlParameterNames.Conversion.DoWarnPCBinariesForAACNotFound, Type = typeof(XmlDoWarnPCBinariesForAACNotFoundParam))]
        [XmlArrayItem(XmlParameterNames.Conversion.ExcludeStringTable, Type = typeof(XmlExcludeStringTableParam))]
        [XmlArrayItem(XmlParameterNames.Conversion.DoOutputPCBinariesForAAC, Type = typeof(XmlDoOutputPCBinariesForAACParam))]
        [XmlArrayItem(XmlParameterNames.Conversion.DoDeleteGarbageOutputBinaries, Type = typeof(XmlDoDeleteGarbageOutputBinariesParam))]
        [XmlArrayItem(XmlParameterNames.Conversion.ExternalFileDirectoryPath, Type = typeof(XmlExternalFileDirectoryPathParam))]
        [XmlArrayItem(XmlParameterNames.Conversion.UserManagementFileOutputDirectoryPath, Type = typeof(XmlUserManagementFileOutputDirectoryPathParam))]
        [XmlArrayItem(XmlParameterNames.Conversion.IntermediateOutputDirectoryPath, Type = typeof(XmlIntermediateOutputDirectoryPathParam))]
        [XmlArrayItem(XmlParameterNames.Conversion.InGameEditCacheOutputDirectoryPath, Type = typeof(XmlInGameEditCacheOutputDirectoryPathParam))]
        [XmlArrayItem(XmlParameterNames.Conversion.IsPostConvertCommandsEnabled, Type = typeof(XmlIsPostConvertCommandsEnabledParam))]
        [XmlArrayItem(XmlParameterNames.Conversion.IsPreConvertCommandsEnabled, Type = typeof(XmlIsPreConvertCommandsEnabledParam))]
        [XmlArrayItem(XmlParameterNames.Conversion.KeepIntermediateTextSequence, Type = typeof(XmlKeepIntermediateTextSequenceParam))]
        [XmlArrayItem(XmlParameterNames.Conversion.OutputLabel, Type = typeof(XmlOutputLabelParam))]
        [XmlArrayItem(XmlParameterNames.Conversion.OutputDirectoryPath, Type = typeof(XmlOutputDirectoryPathParam))]
        [XmlArrayItem(XmlParameterNames.Conversion.SmfTimebase, Type = typeof(XmlSmfTimebaseParam))]
        [XmlArrayItem(XmlParameterNames.Conversion.DoUseBuiltInWavePreprocessExe, Type = typeof(XmlDoUseBuiltInWavePreprocessExeParam))]
        [XmlArrayItem(XmlParameterNames.Conversion.DoUseHardwareOpusDecoder, Type = typeof(XmlDoUseHardwareOpusDecoderParam))]
        [XmlArrayItem(XmlParameterNames.Conversion.WavePreprocessExePath, Type = typeof(XmlWavePreprocessExePathParam))]
        // カスタムパラメータ
        [XmlArrayItem(XmlParameterNames.Custom.Bool, Type = typeof(XmlBoolParam))]
        [XmlArrayItem(XmlParameterNames.Custom.Float, Type = typeof(XmlFloatParam))]
        [XmlArrayItem(XmlParameterNames.Custom.Int, Type = typeof(XmlIntParam))]
        [XmlArrayItem(XmlParameterNames.Custom.String, Type = typeof(XmlStringParam))]
        [XmlArrayItem(XmlParameterNames.Custom.Uint, Type = typeof(XmlUintParam))]
        [XmlArrayItem(XmlParameterNames.Custom.Ulong, Type = typeof(XmlUlongParam))]
        [XmlArrayItem(XmlParameterNames.Custom.Xml, Type = typeof(XmlXmlParam))]
        [XmlArrayItem(XmlParameterNames.Custom.ItemReference, Type = typeof(XmlItemReferenceParam))]
        public List<XmlParameter> Parameters { get; set; }

        [XmlArray("PreConvertCommands")]
        [XmlArrayItem("Command", Type = typeof(string))]
        public List<string> PreConvertCommands { get; set; }

        [XmlArray("PostConvertCommands")]
        [XmlArrayItem("Command", Type = typeof(string))]
        public List<string> PostConvertCommands { get; set; }
    }
}
