﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Xml;
    using System.Xml.Serialization;

    [Serializable]
    [XmlRoot("CommentColumnText", Namespace = XmlNamespaces.Base, IsNullable = false)]
    public class XmlCommentColumnText : IXmlParameterProvider
    {
        [XmlArray("Parameters")]
        // コメントカラム名パラメータ
        [XmlArrayItem(XmlParameterNames.CommentColumnText.Comment, Type = typeof(XmlCommentColumnTextParam))]
        [XmlArrayItem(XmlParameterNames.CommentColumnText.Comment1, Type = typeof(XmlComment1ColumnTextParam))]
        [XmlArrayItem(XmlParameterNames.CommentColumnText.Comment2, Type = typeof(XmlComment2ColumnTextParam))]
        [XmlArrayItem(XmlParameterNames.CommentColumnText.Comment3, Type = typeof(XmlComment3ColumnTextParam))]
        [XmlArrayItem(XmlParameterNames.CommentColumnText.Comment4, Type = typeof(XmlComment4ColumnTextParam))]
        [XmlArrayItem(XmlParameterNames.CommentColumnText.Comment5, Type = typeof(XmlComment5ColumnTextParam))]
        [XmlArrayItem(XmlParameterNames.CommentColumnText.Comment6, Type = typeof(XmlComment6ColumnTextParam))]
        [XmlArrayItem(XmlParameterNames.CommentColumnText.Comment7, Type = typeof(XmlComment7ColumnTextParam))]
        [XmlArrayItem(XmlParameterNames.CommentColumnText.Comment8, Type = typeof(XmlComment8ColumnTextParam))]
        [XmlArrayItem(XmlParameterNames.CommentColumnText.Comment9, Type = typeof(XmlComment9ColumnTextParam))]
        // カスタムパラメータ
        [XmlArrayItem(XmlParameterNames.Custom.Bool, Type = typeof(XmlBoolParam))]
        [XmlArrayItem(XmlParameterNames.Custom.Float, Type = typeof(XmlFloatParam))]
        [XmlArrayItem(XmlParameterNames.Custom.Int, Type = typeof(XmlIntParam))]
        [XmlArrayItem(XmlParameterNames.Custom.String, Type = typeof(XmlStringParam))]
        [XmlArrayItem(XmlParameterNames.Custom.Uint, Type = typeof(XmlUintParam))]
        [XmlArrayItem(XmlParameterNames.Custom.Ulong, Type = typeof(XmlUlongParam))]
        [XmlArrayItem(XmlParameterNames.Custom.Xml, Type = typeof(XmlXmlParam))]
        [XmlArrayItem(XmlParameterNames.Custom.ItemReference, Type = typeof(XmlItemReferenceParam))]
        public List<XmlParameter> Parameters { get; set; }
    }
}
