﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Xml;
    using System.Xml.Serialization;

    [Serializable]
    [XmlRoot("ColorComment", Namespace = XmlNamespaces.Base, IsNullable = false)]
    public class XmlColorComment : IXmlParameterProvider
    {
        [XmlArray("Parameters")]
        // コメントカラム名パラメータ
        [XmlArrayItem(XmlParameterNames.ColorComment.Comment0, Type = typeof(XmlColorComment0TextParam))]
        [XmlArrayItem(XmlParameterNames.ColorComment.Comment1, Type = typeof(XmlColorComment1TextParam))]
        [XmlArrayItem(XmlParameterNames.ColorComment.Comment2, Type = typeof(XmlColorComment2TextParam))]
        [XmlArrayItem(XmlParameterNames.ColorComment.Comment3, Type = typeof(XmlColorComment3TextParam))]
        [XmlArrayItem(XmlParameterNames.ColorComment.Comment4, Type = typeof(XmlColorComment4TextParam))]
        [XmlArrayItem(XmlParameterNames.ColorComment.Comment5, Type = typeof(XmlColorComment5TextParam))]
        [XmlArrayItem(XmlParameterNames.ColorComment.Comment6, Type = typeof(XmlColorComment6TextParam))]
        [XmlArrayItem(XmlParameterNames.ColorComment.Comment7, Type = typeof(XmlColorComment7TextParam))]
        [XmlArrayItem(XmlParameterNames.ColorComment.Comment8, Type = typeof(XmlColorComment8TextParam))]

        // カスタムパラメータ
        [XmlArrayItem(XmlParameterNames.Custom.String, Type = typeof(XmlStringParam))]

        public List<XmlParameter> Parameters { get; set; }
    }
}
