﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using System.Collections.Generic;
    using Core.Parameters;
    using Projects;
    using ToolDevelopmentKit;
    using ToolDevelopmentKit.Collections;

    public class SoundSetItemParamTranslator : CommonItemParamTranslator
    {
        public SoundSetItemParamTranslator()
        {
            // サウンド
            this.AddHandler(ProjectParameterNames.Sound.ChannelPriority, typeof(XmlChannelPriorityParam));
            this.AddHandler(ProjectParameterNames.Sound.PlayerPriority, typeof(XmlPlayerPriorityParam));
            this.AddHandler(ProjectParameterNames.Sound.ReleasePriorityFixed, typeof(XmlReleasePriorityFixedParam));
            this.AddHandler(ProjectParameterNames.Sound.ActorPlayer, typeof(XmlActorPlayerParam));
            this.AddHandler(
                ProjectParameterNames.Sound.Sends, typeof(XmlSendsParam),
                this.XmlSendsParams2Model, this.Model2XmlSendsParams);
            this.AddHandler(
                ProjectParameterNames.Sound.Sound3DParams, typeof(XmlSound3DParam),
                this.XmlSound3DParams2Model, this.Model2XmlSound3DParams);

            this.AddHandler(ProjectParameterNames.Sound.UserParameter, typeof(XmlUserParameterParam));
            this.AddHandler(ProjectParameterNames.Sound.UserParameter1, typeof(XmlUserParameter1Param));
            this.AddHandler(ProjectParameterNames.Sound.UserParameter2, typeof(XmlUserParameter2Param));
            this.AddHandler(ProjectParameterNames.Sound.UserParameter3, typeof(XmlUserParameter3Param));

            this.AddHandler(XmlParameterNames.FrontBypass, typeof(XmlFrontBypassParam));
            this.AddHandler(XmlParameterNames.LPF, typeof(XmlLPFParam));
            this.AddHandler(XmlParameterNames.Biquad, typeof(XmlBiquadParam));

            this.AddHandler(XmlParameterNames.ChannelCount, typeof(XmlChannelCountParam));

            // ストリームサウンド
            this.AddHandler(ProjectParameterNames.StreamSound.IsPrefetchEnabled, typeof(XmlIsPrefetchEnabledParam));

            // ウェーブサウンド
            this.AddHandler(ProjectParameterNames.WaveSound.EnvelopeRelease, typeof(XmlEnvelopeReleaseParam));

            // シーケンスサウンド
            this.AddHandler(
                ProjectParameterNames.SequenceSound.SoundSetBankReferences, typeof(XmlSoundSetBankReferencesParam),
                this.XmlSoundSetBankReferencesParams2Model, this.Model2XmlSoundSetBankReferencesParams);
            this.AddHandler(
                ProjectParameterNames.SequenceSound.FileType, typeof(XmlSequenceSoundFileTypeParam),
                this.XmlSequenceSoundFileTypeParam2Model, this.Model2XmlSequenceSoundFileTypeParam);
            this.AddHandler(ProjectParameterNames.SequenceSound.StartPosition, typeof(XmlStartPositionParam));

            // 波形アーカイブ
            this.AddHandler(
               ProjectParameterNames.WaveArchive.LoadType, typeof(XmlWaveArchiveLoadTypeParam),
               this.XmlWaveArchiveLoadTypeParam2Model, this.Model2XmlWaveArchiveLoadTypeParam);

            // グループ
            this.AddHandler(
               ProjectParameterNames.Group.OutputType, typeof(XmlGroupOutputTypeParam),
               this.XmlGroupOutputTypeParam2Model, this.Model2XmlGroupOutputTypeParam);

            // プレイヤー
            this.AddHandler(ProjectParameterNames.Player.HeapSize, typeof(XmlPlayerHeapSizeParam));
            this.AddHandler(ProjectParameterNames.Player.SoundLimit, typeof(XmlPlayerSoundLimitParam));

            // 3Dサウンド
            this.AddHandler(
                XmlParameterNames.Sound3D.DecayCurve3D, typeof(XmlDecayCurve3DParam),
                this.XmlDecayCurve3DParam2Model, this.Model2XmlDecayCurve3DParam);
            this.AddHandler(XmlParameterNames.Sound3D.DecayRatio3D, typeof(XmlDecayRatio3DParam));
            this.AddHandler(XmlParameterNames.Sound3D.DopplerFactor3D, typeof(XmlDopplerFactor3DParam));
            this.AddHandler(XmlParameterNames.Sound3D.Enable3DFilter, typeof(XmlEnable3DFilterParam));
            this.AddHandler(XmlParameterNames.Sound3D.Enable3DPan, typeof(XmlEnable3DPanParam));
            this.AddHandler(XmlParameterNames.Sound3D.Enable3DPriority, typeof(XmlEnable3DPriorityParam));
            this.AddHandler(XmlParameterNames.Sound3D.Enable3DSurroundPan, typeof(XmlEnable3DSurroundPanParam));
            this.AddHandler(XmlParameterNames.Sound3D.Enable3DVolume, typeof(XmlEnable3DVolumeParam));
        }

        //-----------------------------------------------------------------
        // DecayCurve3D
        //-----------------------------------------------------------------

        private void XmlDecayCurve3DParam2Model(XmlParameter paramXml, IParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramXml);
            Assertion.Argument.NotNull(dest);

            XmlDecayCurve3DParam src = paramXml as XmlDecayCurve3DParam;
            DecayCurve3D value = DecayCurve3DEx.Parse(src.Value);

            this.SetParameterValue(dest, src.Name, value);
        }

        private void Model2XmlDecayCurve3DParam(
            string paramName, IParameterValue value, Type xmlParamType, IXmlParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramName);
            Assertion.Argument.NotNull(value);
            Assertion.Argument.True(value is DecayCurve3DParameterValue);
            Assertion.Argument.NotNull(xmlParamType);
            Assertion.Argument.NotNull(dest);

            XmlDecayCurve3DParam destValue = new XmlDecayCurve3DParam()
            {
                Value = (value as DecayCurve3DParameterValue).Value.ToText(),
            };

            dest.Parameters.Add(destValue);
        }

        //-----------------------------------------------------------------
        // SequenceSoundFileType
        //-----------------------------------------------------------------

        private void XmlSequenceSoundFileTypeParam2Model(XmlParameter paramXml, IParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramXml);
            Assertion.Argument.NotNull(dest);

            XmlSequenceSoundFileTypeParam src = paramXml as XmlSequenceSoundFileTypeParam;
            SequenceSoundFileType value = SequenceSoundFileTypeEx.Parse(src.Value);

            this.SetParameterValue(dest, src.Name, value);
        }

        private void Model2XmlSequenceSoundFileTypeParam(
            string paramName, IParameterValue value, Type xmlParamType, IXmlParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramName);
            Assertion.Argument.NotNull(value);
            Assertion.Argument.True(value is SequenceSoundFileTypeParameterValue);
            Assertion.Argument.NotNull(xmlParamType);
            Assertion.Argument.NotNull(dest);

            XmlSequenceSoundFileTypeParam destValue = new XmlSequenceSoundFileTypeParam()
            {
                Value = (value as SequenceSoundFileTypeParameterValue).Value.ToText(),
            };

            dest.Parameters.Add(destValue);
        }

        //-----------------------------------------------------------------
        // SoundSetBankReferences
        //-----------------------------------------------------------------

        private const int BankReferenceCount = 4;

        private void XmlSoundSetBankReferencesParams2Model(XmlParameter paramXml, IParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramXml);
            Assertion.Argument.NotNull(dest);

            XmlSoundSetBankReferencesParam src = paramXml as XmlSoundSetBankReferencesParam;
            ComponentReferenceCollection destValue =
                dest.Parameters[src.Name] as ComponentReferenceCollection;

            foreach (XmlSoundSetBankReferenceParam xmlBankReference in src.Value)
            {
                destValue.Value.Add(
                    new ComponentReference()
                    {
                        TargetName = xmlBankReference.Target,
                    });
            }

            for (int count = 0; count < BankReferenceCount - src.Value.Count; count++)
            {
                destValue.Value.Add
                    (new ComponentReference() { TargetName = String.Empty, });
            }
        }

        private void Model2XmlSoundSetBankReferencesParams(
            string paramName, IParameterValue value, Type xmlParamType, IXmlParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramName);
            Assertion.Argument.NotNull(value);
            Assertion.Argument.True(value is ComponentReferenceCollection);
            Assertion.Argument.NotNull(xmlParamType);
            Assertion.Argument.NotNull(dest);

            ComponentReferenceCollection srcValue = value as ComponentReferenceCollection;
            XmlSoundSetBankReferencesParam destValue = new XmlSoundSetBankReferencesParam()
            {
                Value = new List<XmlSoundSetBankReferenceParam>(),
            };

            foreach (ComponentReference soundSetBankReference in srcValue.Value)
            {
                destValue.Value.Add(
                     new XmlSoundSetBankReferenceParam()
                     {
                         Target = soundSetBankReference.TargetName,
                     }
                     );
            }

            dest.Parameters.Add(destValue);
        }

        //-----------------------------------------------------------------
        // Sends
        //-----------------------------------------------------------------

        private void XmlSendsParams2Model(XmlParameter paramXml, IParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramXml);
            Assertion.Argument.NotNull(dest);

            XmlSendsParam src = paramXml as XmlSendsParam;
            //SendsParameterValue destValue = dest.Parameters[src.Name] as SendsParameterValue;
            IParameterProvider destValue = dest.Parameters[src.Name] as IParameterProvider;

            foreach (XmlSend xmlSend in src.Value)
            {
                if (!destValue.Parameters.ContainsKey(xmlSend.Name)) { continue; }
                destValue.Parameters[xmlSend.Name].Value = xmlSend.Value;
            }
        }

        private void Model2XmlSendsParams(
            string paramName, IParameterValue value, Type xmlParamType, IXmlParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramName);
            Assertion.Argument.NotNull(value);
            //Assertion.Argument.True(value is SendsParameterValue);
            Assertion.Argument.True(value is IParameterProvider);
            Assertion.Argument.NotNull(xmlParamType);
            Assertion.Argument.NotNull(dest);

            //SendsParameterValue srcValue = value as SendsParameterValue;
            IParameterProvider srcValue = value as IParameterProvider;
            XmlSendsParam destValue = new XmlSendsParam()
            {
                Value = new List<XmlSend>(),
            };

            foreach (string key in srcValue.Parameters.Keys)
            {
                destValue.Value.Add(
                    new XmlSend()
                    {
                        Name = key,
                        Value = (int)srcValue.Parameters[key].Value,
                    }
                    );
            }

            dest.Parameters.Add(destValue);
        }

        //-----------------------------------------------------------------
        // Sound3D Params
        //-----------------------------------------------------------------

        private void XmlSound3DParams2Model(XmlParameter paramXml, IParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramXml);
            Assertion.Argument.NotNull(dest);

            XmlSound3DParam src = paramXml as XmlSound3DParam;
            Sound3DParameterValue destValue = dest.Parameters[src.Name] as Sound3DParameterValue;

            foreach (XmlParameter xmlParameter in src.Parameters)
            {
                this.Xml2Model(xmlParameter, destValue);
            }
        }

        private void Model2XmlSound3DParams(
            string paramName, IParameterValue value, Type xmlParamType, IXmlParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramName);
            Assertion.Argument.NotNull(value);
            Assertion.Argument.True(value is Sound3DParameterValue);
            Assertion.Argument.NotNull(xmlParamType);
            Assertion.Argument.NotNull(dest);

            Sound3DParameterValue srcValue = value as Sound3DParameterValue;
            XmlSound3DParam destValue = new XmlSound3DParam();

            foreach (string key in srcValue.Parameters.Keys)
            {
                this.Model2Xml(key, srcValue.Parameters[key], destValue);
            }

            dest.Parameters.Add(destValue);
        }

        //-----------------------------------------------------------------
        // WaveArchiveLoadType
        //-----------------------------------------------------------------

        private void XmlWaveArchiveLoadTypeParam2Model(XmlParameter paramXml, IParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramXml);
            Assertion.Argument.NotNull(dest);

            XmlWaveArchiveLoadTypeParam src = paramXml as XmlWaveArchiveLoadTypeParam;
            WaveArchiveLoadType value = WaveArchiveLoadTypeEx.Parse(src.Value);

            this.SetParameterValue(dest, src.Name, value);
        }

        private void Model2XmlWaveArchiveLoadTypeParam(
            string paramName, IParameterValue value, Type xmlParamType, IXmlParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramName);
            Assertion.Argument.NotNull(value);
            Assertion.Argument.True(value is WaveArchiveLoadTypeParameterValue);
            Assertion.Argument.NotNull(xmlParamType);
            Assertion.Argument.NotNull(dest);

            XmlWaveArchiveLoadTypeParam destValue = new XmlWaveArchiveLoadTypeParam()
            {
                Value = (value as WaveArchiveLoadTypeParameterValue).Value.ToText(),
            };

            dest.Parameters.Add(destValue);
        }

        //-----------------------------------------------------------------
        // GroupOutputType
        //-----------------------------------------------------------------

        private void XmlGroupOutputTypeParam2Model(XmlParameter paramXml, IParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramXml);
            Assertion.Argument.NotNull(dest);

            XmlGroupOutputTypeParam src = paramXml as XmlGroupOutputTypeParam;
            GroupOutputType value = GroupOutputTypeEx.Parse(src.Value);

            this.SetParameterValue(dest, src.Name, value);
        }

        private void Model2XmlGroupOutputTypeParam(
            string paramName, IParameterValue value, Type xmlParamType, IXmlParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramName);
            Assertion.Argument.NotNull(value);
            Assertion.Argument.True(value is GroupOutputTypeParameterValue);
            Assertion.Argument.NotNull(xmlParamType);
            Assertion.Argument.NotNull(dest);

            XmlGroupOutputTypeParam destValue = new XmlGroupOutputTypeParam()
            {
                Value = (value as GroupOutputTypeParameterValue).Value.ToText(),
            };

            dest.Parameters.Add(destValue);
        }
    }
}
