﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.SoundFoundation.Resources;

namespace NintendoWare.SoundFoundation.Core
{
    /// <summary>
    /// 検証の結果を格納します。
    /// </summary>
    public class ValidationResult
    {
        public static readonly ValidationResult NoError = new ValidationResult(true);

        private bool _isValid = false;
        private string _text = string.Empty;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="isValid">検証の結果。</param>
        public ValidationResult(bool isValid) : this(isValid, string.Empty) { }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="isValid">検証の結果。</param>
        /// <param name="text">ローカライズされたテキスト。</param>
        public ValidationResult(bool isValid, string text)
        {
            _isValid = isValid;
            _text = (null != text) ? text : string.Empty;
        }

        /// <summary>
        /// 検証の結果が有効だったかどうかを取得します。
        /// </summary>
        public bool IsValid
        {
            get { return _isValid; }
        }

        /// <summary>
        /// ローカライズされたテキストを取得します。
        /// </summary>
        /// <returns>ローカライズされたテキスト</returns>
        public override string ToString()
        {
            if (0 < _text.Length) { return _text; }
            return (_isValid) ? MessageResource.Message_Valid : MessageResource.Message_Invalid;
        }
    }
}
