﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using NintendoWare.SoundFoundation.Resources;

namespace NintendoWare.SoundFoundation.Core
{
    /// <summary>
    /// 範囲外の値が格納されている場合に返される検証結果。
    /// </summary>
    public class OutOfRangeValidationResult : ValidationResult
    {
        private string _text = string.Empty;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public OutOfRangeValidationResult(object from, object to) : this(from, to, string.Empty) { }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="from">範囲の開始値。</param>
        /// <param name="to">範囲の終了値。</param>
        /// <param name="frontingText">前置文。</param>
        public OutOfRangeValidationResult(object from, object to, string frontingText)
            : base(false)
        {
            _text = CreateText(from, to, (null == frontingText) ? string.Empty : frontingText);
        }

        /// <summary>
        /// ローカライズされたテキストを取得します。
        /// </summary>
        /// <returns>ローカライズされたテキスト</returns>
        public override string ToString()
        {
            return _text;
        }

        /// <summary>
        /// テキストを作成します。
        /// </summary>
        /// <param name="from">範囲の開始値。</param>
        /// <param name="to">範囲の終了値。</param>
        /// <param name="frontingText">前置文。</param>
        /// <returns>作成したテキスト。</returns>
        private string CreateText(object from, object to, string frontingText)
        {
            if (null == from) { throw new ArgumentNullException("from"); }
            if (null == to) { throw new ArgumentNullException("to"); }
            if (null == frontingText) { throw new ArgumentNullException("frontingText"); }

            return frontingText + string.Format(MessageResource.Message_OutOfRange,
                                                 from.ToString(), to.ToString());
        }
    }
}
